/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.lucidworks.connector.plugins.jdbc.inject.provider.DriverPath;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverPathProvider
implements Provider<DriverPath> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DriverPathProvider.class);
    private static final String TMP_FOLDER = "/tmp/lucidworks.jdbc";
    private final DriverPath driverJar = DriverPathProvider::jdbDriverPath;

    @Inject
    public DriverPathProvider() {
    }

    public DriverPath get() {
        return this.driverJar;
    }

    static Path jdbDriverPath() {
        Path jdbcDriverJarPath = Path.of(DriverPathProvider.path(), new String[0]);
        logger.info("Using path={} to add the jdbc jar.", (Object)jdbcDriverJarPath);
        File directory = jdbcDriverJarPath.toFile();
        if (!directory.exists()) {
            logger.info("Path={} does not exists. Creating ... ", (Object)jdbcDriverJarPath);
            directory.mkdirs();
        }
        return jdbcDriverJarPath;
    }

    static String path() {
        return DriverPathProvider.fromPluginDir().orElseGet(() -> DriverPathProvider.fromClassLoader().orElseGet(DriverPathProvider::tmpLocation));
    }

    static String tmpLocation() {
        logger.warn("Using path={} to place the jdbc jar", (Object)TMP_FOLDER);
        return TMP_FOLDER;
    }

    static Optional<String> fromPluginDir() {
        return Optional.ofNullable(System.getProperty("plugin.dir")).map(p -> {
            logger.info("plugin.dir={}", p);
            return p + "/drivers";
        });
    }

    static Optional<String> fromClassLoader() {
        try {
            File driver = new File(DriverPathProvider.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            File parent = driver.getParentFile().getParentFile();
            logger.info("From DriverPathProvider class={}", (Object)parent);
            return Optional.of(parent.getAbsolutePath() + "/drivers");
        }
        catch (URISyntaxException e) {
            logger.warn("Failing to get the Classloader from Provider class.", (Throwable)e);
            return Optional.empty();
        }
    }
}

