/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.inject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;

public class CachingClassLoader
extends ClassLoader {
    private Deque<ClassLoader> classLoaders = new ArrayDeque<ClassLoader>();

    public CachingClassLoader(ClassLoader parent) {
        this.classLoaders.push(parent);
    }

    public void addUrls(URL ... urls) {
        this.classLoaders.push(new URLClassLoader(urls, this.getCurrentClassLoader()));
    }

    public ClassLoader getCurrentClassLoader() {
        return this.classLoaders.peek();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getCurrentClassLoader().loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.getCurrentClassLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getCurrentClassLoader().getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.getCurrentClassLoader().getResourceAsStream(name);
    }
}

