/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.processor;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.nestedquery.NestedQueryResolver;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.fetcher.output.JdbcTypedDocument;
import com.lucidworks.connector.plugins.jdbc.input.RowInput;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowProcessor
extends Processor<RowInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RowProcessor.class);
    private final NestedQueryResolver nestedQueryResolver;

    @Inject
    public RowProcessor(NestedQueryResolver nestedQueryResolver) {
        this.nestedQueryResolver = nestedQueryResolver;
    }

    public FetchResult process(TypedEmitter ctx, RowInput input) {
        try {
            logger.info("Processing row with ID [{}]", (Object)input.inputId());
            HashMap<String, Object> document = new HashMap<String, Object>(input.document());
            Map<String, List<Object>> nested = this.nestedQueryResolver.getNestedQueries(input.inputId(), input.document().keySet());
            document.putAll(nested);
            ctx.emitDocument(() -> new JdbcTypedDocument(input, document));
        }
        catch (JdbcException e) {
            logger.error("Error while getting nested queries", (Throwable)e);
            ctx.emitError((GsonModel.TypedInput)input, e.getMessage());
        }
        return ctx.newResult();
    }
}

