/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.processor;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.iterator.JdbcIterator;
import com.lucidworks.connector.plugins.jdbc.fetcher.configurator.ConfigWrapper;
import com.lucidworks.connector.plugins.jdbc.fetcher.output.JdbcTypedDocument;
import com.lucidworks.connector.plugins.jdbc.input.CheckpointInput;
import com.lucidworks.connector.plugins.jdbc.input.JdbcQuery;
import com.lucidworks.connector.plugins.jdbc.input.PageInput;
import com.lucidworks.connector.plugins.jdbc.input.RowInput;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.MapBuilder;
import com.lucidworks.fusion.schema.ModelGenerator;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageProcessor
extends Processor<PageInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(PageProcessor.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final Client client;
    private final ConfigWrapper config;
    private final String startTime;

    @Inject
    public PageProcessor(Client client, ConfigWrapper config) {
        this.client = client;
        this.config = config;
        this.startTime = PageProcessor.getCurrentTimestamp();
    }

    public FetchResult process(TypedEmitter ctx, PageInput input) {
        logger.info("Processing page with offset [{}]", (Object)input.offset());
        JdbcQuery query = JdbcQuery.builder().query(input.query()).limit(this.config.batchSize()).offset(input.offset()).build();
        try (JdbcIterator iterator = this.client.executeQuery(query);){
            iterator.forEachRemaining(document -> {
                RowInput row = RowInput.builder().inputId(String.valueOf(document.getOrDefault(this.config.primaryKey(), ModelGenerator.randomId()))).parentId(input.inputId()).strayContentDeletionEnabled(this.config.strayContentDeletionEnabled()).document(PageProcessor.toMapBuilder(document)).build();
                logger.debug("Processing row={} size={}", (Object)row.inputId(), (Object)row.document().size());
                if (!this.config.hasNestedQueries() && !this.config.strayContentDeletionEnabled()) {
                    ctx.emitDocument(() -> new JdbcTypedDocument(row, row.document()));
                    return;
                }
                ctx.emitCandidate(row::toCandidate);
            });
            if (iterator.getTotalCount() == this.config.batchSize()) {
                PageInput pageInput = PageInput.builder().query(input.query()).offset(input.offset() + this.config.batchSize()).parentId(input.parentId()).build();
                ctx.emitCandidate(pageInput::toCandidate);
            } else {
                CheckpointInput checkpoint = CheckpointInput.builder().created(this.startTime).build();
                ctx.emitCheckpoint(checkpoint::toCheckpoint);
            }
        }
        catch (Exception e) {
            logger.error("Error while iterating results", (Throwable)e);
            ctx.emitError((GsonModel.TypedInput)input, e.getMessage());
        }
        return ctx.newResult();
    }

    public static String getCurrentTimestamp() {
        return ZonedDateTime.now(Clock.systemUTC()).format(DATE_FORMATTER);
    }

    private static Map<String, Object> toMapBuilder(Map<String, Object> document) {
        Consumer<MapBuilder> mapBuilderConsumer = JdbcTypedDocument.toMapBuilder(document);
        MapBuilder builder = new MapBuilder();
        mapBuilderConsumer.accept(builder);
        return builder.build();
    }
}

