/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher.paginator;

import com.google.common.base.Strings;
import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.config.JdbcConfig;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paginator {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Paginator.class);
    private static final double IBM_DB2_VERSION_WITH_DEFAULT_PAGINATION_SUPPORT = 11.5;
    private final Client client;

    @Inject
    public Paginator(Client client) {
        this.client = client;
    }

    public String getPaginatedQueryIfAvailable(JdbcConfig.Properties properties) {
        if (this.shouldAddPagination(properties)) {
            return this.getPaginatedQuery(properties);
        }
        return properties.query();
    }

    public boolean shouldAddPagination(JdbcConfig.Properties properties) {
        boolean shouldAddPagination = !Strings.isNullOrEmpty((String)properties.query()) && !this.isQueryAlreadyPaginated(properties.query()) && properties.enableAutomaticPagination() != false;
        logger.info("Automatic pagination is going to be added = [{}]", (Object)shouldAddPagination);
        return shouldAddPagination;
    }

    public boolean isQueryAlreadyPaginated(String query) {
        String queryUpperCase = query.toUpperCase();
        boolean isQueryAlreadyPaginated = queryUpperCase.contains(" OFFSET ") || queryUpperCase.contains(" LIMIT ") || queryUpperCase.contains(" ROW ONLY") || queryUpperCase.contains(" ROWS ONLY");
        logger.info("Pagination detected in original query = [{}]", (Object)isQueryAlreadyPaginated);
        return isQueryAlreadyPaginated;
    }

    public String getPaginatedQuery(JdbcConfig.Properties properties) {
        Object paginatedQuery = this.removeSubqueryComment(properties.query());
        paginatedQuery = ((String)paginatedQuery).replace(";", "");
        if (!Strings.isNullOrEmpty((String)properties.driver())) {
            if (properties.driver().toLowerCase().contains("mysql") || properties.driver().toLowerCase().contains("postgres")) {
                paginatedQuery = (String)paginatedQuery + String.format(" LIMIT %s OFFSET %s", "${limit}", "${offset}");
            } else if (properties.driver().toLowerCase().contains("sqlserver")) {
                paginatedQuery = (String)paginatedQuery + String.format(" ORDER BY %s OFFSET %s ROWS FETCH NEXT %s ROWS ONLY", properties.primaryKey(), "${offset}", "${limit}");
            } else if (properties.driver().toLowerCase().contains("oracle")) {
                paginatedQuery = (String)paginatedQuery + String.format(" OFFSET %s ROWS FETCH NEXT %s ROWS ONLY", "${offset}", "${limit}");
            } else if (properties.driver().toLowerCase().contains("db2")) {
                Double databaseVersion = null;
                databaseVersion = this.getDatabaseVersion();
                if (databaseVersion != null) {
                    paginatedQuery = this.shouldPaginateUsingSubquery(databaseVersion, properties.query()) ? this.getPaginatedQueryForOlderIBMDB2((String)paginatedQuery) : this.getPaginatedQueryForNewerIBMDB2((String)paginatedQuery);
                } else {
                    logger.info("Will NOT paginate query because failed to get IBM DB2 database version to determine the supported query format to use");
                }
            } else {
                logger.info("Automatic pagination NOT supported for Driver [{}], will not paginate query", (Object)properties.driver());
            }
        }
        logger.info("Final resulting paginated query [{}]", paginatedQuery);
        return paginatedQuery;
    }

    public Double getDatabaseVersion() {
        Double databaseVersion = null;
        try {
            databaseVersion = this.client.getDatabaseVersion();
        }
        catch (Exception exception) {
            logger.error("Error while getting database version", (Throwable)exception);
        }
        logger.info("Database version = {}", (Object)databaseVersion);
        return databaseVersion;
    }

    public String getPaginatedQueryForOlderIBMDB2(String originalQuery) {
        logger.info("Pagination will be done using a subquery");
        String originalQueryWithoutTable = originalQuery.substring(0, originalQuery.toUpperCase().indexOf(" FROM "));
        String originalQueryTablePortion = originalQuery.substring(originalQuery.toUpperCase().indexOf(" FROM "));
        return String.format("SELECT * FROM (%s , ROW_NUMBER() OVER () AS row_num %s) AS subquery WHERE row_num BETWEEN (%s + 1) AND (%s + %s)", originalQueryWithoutTable, originalQueryTablePortion, "${offset}", "${offset}", "${limit}");
    }

    public String getPaginatedQueryForNewerIBMDB2(String originalQuery) {
        logger.info("Pagination will be done using OFFSET and ROWS ONLY");
        return originalQuery + String.format(" OFFSET %s ROWS FETCH NEXT %s ROWS ONLY", "${offset}", "${limit}");
    }

    public boolean shouldPaginateUsingSubquery(double databaseVersion, String originalQuery) {
        return databaseVersion < 11.5 || originalQuery.toLowerCase().contains("--subquery") || originalQuery.toLowerCase().contains("-- subquery");
    }

    public String removeSubqueryComment(String query) {
        return query.replace("--subquery", "").replace("-- subquery", "");
    }
}

