/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.fetcher;

import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.nestedquery.NestedQueryResolver;
import com.lucidworks.connectors.components.processor.ProcessorRunner;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.StartResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.StopResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcFetcher
implements ContentFetcher {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcFetcher.class);
    public static final String NAME = "content";
    private final ProcessorRunner processorRunner;
    private final Client client;
    private final NestedQueryResolver nestedQueryResolver;

    @Inject
    public JdbcFetcher(ProcessorRunner processorRunner, Client client, NestedQueryResolver nestedQueryResolver) {
        this.processorRunner = processorRunner;
        this.client = client;
        this.nestedQueryResolver = nestedQueryResolver;
    }

    public StartResult start(ContentFetcher.StartContext context) {
        logger.debug("Starting fetcher context={}", (Object)context);
        return context.newResult();
    }

    public FetchResult fetch(ContentFetcher.FetchContext ctx) {
        FetchInput input = ctx.getFetchInput();
        logger.trace("Fetching input={}", (Object)input);
        return this.processorRunner.process(ctx, input);
    }

    public StopResult stop(ContentFetcher.StopContext context) {
        logger.info("Stopping fetcher context={}", (Object)context);
        this.client.close();
        this.nestedQueryResolver.close();
        return context.newResult();
    }
}

