/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.config;

import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorPluginProperties;
import com.lucidworks.fusion.connector.plugin.api.config.MaximumItemLimitConfig;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

@SchemaAnnotations.RootSchema(title="JDBC (v2)", description="Connector to index content in a database.", category="Database")
public interface JdbcConfig
extends ConnectorConfig<Properties> {
    @SchemaAnnotations.Property(title="JDBC properties", required=true)
    public Properties properties();

    @SchemaAnnotations.Property(required=true)
    public String parserId();

    public static interface Properties
    extends MaximumItemLimitConfig,
    ConnectorPluginProperties {
        @SchemaAnnotations.Property(title="JDBC URL", description="A URL to the database, e.g., 'jdbc:mysql://localhost/test'", required=true, order=1)
        @SchemaAnnotations.StringSchema
        public String url();

        @SchemaAnnotations.Property(title="JDBC driver", required=true, description="The class name of the JDBC driver to use to connect to the database.", order=2)
        @SchemaAnnotations.StringSchema
        public String driver();

        @SchemaAnnotations.Property(title="SQL statement", description="A SQL SELECT statement to choose the records to be retrieved. For paginated queries, use the special variables ${limit} and ${offset}. The specific syntax will be driver dependent. Examples: Mysql - SELECT * FROM test_table LIMIT ${limit} OFFSET ${offset}, Microsoft SQLServer - SELECT * FROM test_table ORDER BY primary_key OFFSET ${offset} FETCH NEXT ${limit} ROWS ONLY", required=true, order=3)
        @SchemaAnnotations.StringSchema
        public String query();

        @SchemaAnnotations.Property(title="Limit", description="Limiter to paginate the results returned. Max amount of records to return at a time", hints={"hidden"})
        @SchemaAnnotations.NumberSchema(defaultValue=10000.0)
        public Integer limit();

        @SchemaAnnotations.Property(title="Fetch starting offset", description="Starting number for records fetch. Such as starting from the 10th record", hints={"hidden"})
        @SchemaAnnotations.NumberSchema(defaultValue=0.0)
        public Integer offset();

        @SchemaAnnotations.Property(title="Disable Automatic Pagination", description="Disable automatic pagination such that limit and offset fields will be ignored", hints={"hidden"})
        @SchemaAnnotations.BooleanSchema(defaultValue=false)
        public Boolean disableAutomaticPagination();

        @SchemaAnnotations.Property(title="Enable Automatic Pagination", description="Enabled automatic pagination such that pagination will be done as long as criteria is met", order=6)
        @SchemaAnnotations.BooleanSchema(defaultValue=true)
        public Boolean enableAutomaticPagination();

        @SchemaAnnotations.Property(title="Delta SQL Query", order=7, description="An optional second query that will be used on re-crawls. It is intended to be used to save performance by returning only new/modified items. It's not allowed if Stray Content Deletion is enabled.")
        @SchemaAnnotations.StringSchema
        public String deltaQuery();

        @SchemaAnnotations.Property(title="Nested SQL Queries", description="A nested query to join data from multiple tables. The nested query will be used with the SQL Statement and must include the primary key with the ${id} template. For example, 'SELECT column FROM table_fk WHERE pk_id=${id}'.", order=8)
        @SchemaAnnotations.ArraySchema
        @SchemaAnnotations.StringSchema
        public List<String> nestedQueries();

        @SchemaAnnotations.Property(title="Enable Stray Content Deletion", description="When this feature is enabled, items not returned by the SQL query used for the crawl will be deleted from the content collection after each crawl. If it is disabled, no checks are performed for data freshness.", order=9)
        @SchemaAnnotations.BooleanSchema(defaultValue=true)
        public Boolean strayContentDeletionEnabled();

        @SchemaAnnotations.Property(title="Primary key", description="The column name of the primary key for the table.", required=true, order=10)
        @SchemaAnnotations.StringSchema(defaultValue="id")
        public String primaryKey();

        @SchemaAnnotations.Property(title="username", description="The username of a database account used for authentication and data access.", order=11)
        @SchemaAnnotations.StringSchema
        public String username();

        @SchemaAnnotations.Property(title="password", description="The password of the account used for authentication and data access.", order=12)
        @SchemaAnnotations.StringSchema(encrypted=true)
        public String password();

        @SchemaAnnotations.Property(title="Batch size", description="Size of the batch during the statement execution", order=13)
        @SchemaAnnotations.NumberSchema(defaultValue=5000.0)
        public Integer batchSize();

        @SchemaAnnotations.Property(title="Maximum of open connections", description="Maximum of connections in parallel to be used during statements execution", order=14)
        @SchemaAnnotations.NumberSchema(defaultValue=20.0)
        public Integer maxConnections();

        @SchemaAnnotations.Property(title="Nested query timeout", description="Timeout in minutes while executing a nested query statement", order=15)
        @SchemaAnnotations.NumberSchema(defaultValue=1.0)
        public Integer nestedQueryTimeOut();

        @SchemaAnnotations.Property(title="Skip Connection Validation", description="Sometimes the validation can take long time, it is better to skip it.", order=16)
        @SchemaAnnotations.BooleanSchema(defaultValue=false)
        public Boolean skipValidation();
    }
}

