/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.row;

import com.lucidworks.connector.plugins.jdbc.client.result.JdbcQueryResult;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.input.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRows
implements AutoCloseable {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcRows.class);
    private final JdbcQueryResult queryResult;
    private final List<Column> columns;
    private final Map<String, List<Object>> result;

    public JdbcRows(JdbcQueryResult queryResult, List<Column> columns) {
        this.queryResult = queryResult;
        this.columns = columns;
        this.result = new HashMap<String, List<Object>>();
    }

    public Map<String, List<Object>> fetch() throws JdbcException {
        try {
            this.columns.forEach(column -> this.result.put(column.name(), new ArrayList()));
            while (this.queryResult.hasNext()) {
                this.columns.forEach(this::processColumn);
            }
        }
        catch (Exception e) {
            throw JdbcException.create(e.getMessage(), e);
        }
        return this.result;
    }

    @Override
    public void close() {
        this.queryResult.close();
    }

    private void processColumn(Column column) {
        this.result.computeIfPresent(column.name(), (key, values) -> {
            try {
                values.add(this.queryResult.getObject(column.index(), column.type()));
            }
            catch (Exception e) {
                logger.warn("Skipping value of column={} due {}", (Object)column.name(), (Object)e.getMessage());
                logger.debug("Error decoding column ", (Throwable)e);
            }
            return values;
        });
    }
}

