/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.connection.datasource;

import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataSource
implements AutoCloseable {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataSource.class);
    private final HikariDataSource dataSource;

    public JdbcDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws JdbcException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws JdbcException {
        this.dataSource.close();
    }
}

