/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client.column;

import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcRuntimeException;
import com.lucidworks.connector.plugins.jdbc.inject.DriversClassLoader;
import com.lucidworks.connector.plugins.jdbc.input.Column;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnResolver {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ColumnResolver.class);
    private final DriversClassLoader classloader;

    @Inject
    public ColumnResolver(DriversClassLoader classloader) {
        this.classloader = classloader;
    }

    public List<Column> getColumns(ResultSetMetaData rsMetaData) throws JdbcException {
        try {
            return IntStream.rangeClosed(1, rsMetaData.getColumnCount()).mapToObj(index -> this.buildColumn(index, rsMetaData)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    public List<Column> getNestedColumns(ResultSetMetaData rsMetaData, Set<String> knownColumns, String fieldPrefix) throws JdbcException {
        try {
            return IntStream.rangeClosed(1, rsMetaData.getColumnCount()).mapToObj(index -> this.buildNestedColumn(index, rsMetaData, knownColumns, fieldPrefix)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw JdbcException.create(e.getMessage(), e);
        }
    }

    private Column buildColumn(int index, ResultSetMetaData rsMetaData) {
        try {
            Class<?> type = this.classloader.loadClass(rsMetaData.getColumnClassName(index));
            return Column.builder().name(rsMetaData.getColumnLabel(index)).type(type).index(index).build();
        }
        catch (Exception e) {
            throw JdbcRuntimeException.create(e.getMessage(), e);
        }
    }

    private Column buildNestedColumn(int index, ResultSetMetaData rsMetaData, Set<String> knownColumns, String fieldPrefix) {
        try {
            String columnName;
            Class<?> type = this.classloader.loadClass(rsMetaData.getColumnClassName(index));
            String columnLabel = rsMetaData.getColumnLabel(index);
            if (knownColumns.stream().anyMatch(columnLabel::equalsIgnoreCase)) {
                String capitalizedColumnName = columnLabel.substring(0, 1).toUpperCase() + columnLabel.substring(1);
                columnName = String.format("%s%s", fieldPrefix, capitalizedColumnName);
            } else {
                columnName = columnLabel;
            }
            return Column.builder().name(columnName).type(type).index(index).build();
        }
        catch (Exception e) {
            throw JdbcRuntimeException.create(e.getMessage(), e);
        }
    }
}

