/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.jdbc.client;

import com.lucidworks.connector.plugins.jdbc.client.Client;
import com.lucidworks.connector.plugins.jdbc.client.column.ColumnResolver;
import com.lucidworks.connector.plugins.jdbc.client.connection.ConnectionPool;
import com.lucidworks.connector.plugins.jdbc.client.iterator.JdbcIterator;
import com.lucidworks.connector.plugins.jdbc.client.result.JdbcQueryResult;
import com.lucidworks.connector.plugins.jdbc.client.row.JdbcRows;
import com.lucidworks.connector.plugins.jdbc.exception.JdbcException;
import com.lucidworks.connector.plugins.jdbc.input.Column;
import com.lucidworks.connector.plugins.jdbc.input.JdbcNestedQuery;
import com.lucidworks.connector.plugins.jdbc.input.JdbcQuery;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
extends Client {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DefaultClient.class);
    private final ColumnResolver columnResolver;

    @Inject
    public DefaultClient(ConnectionPool connectionPool, ColumnResolver columnResolver) {
        super(connectionPool);
        this.columnResolver = columnResolver;
    }

    @Override
    public JdbcIterator executeQuery(JdbcQuery query) throws JdbcException {
        logger.debug("Query: [{}]", (Object)query.sql());
        JdbcQueryResult result = this.execute(query.sql(), query.limit());
        List<Column> columns = this.columnResolver.getColumns(result.getMetaData());
        return new JdbcIterator(result, columns);
    }

    @Override
    public JdbcRows executeNestedQuery(JdbcNestedQuery query) throws JdbcException {
        logger.info("Nested query: [{}]", (Object)query);
        JdbcQueryResult result = this.execute(query.query(), query.fetchSize());
        List<Column> columns = this.columnResolver.getNestedColumns(result.getMetaData(), query.knownColumns(), query.fieldPrefix());
        return new JdbcRows(result, columns);
    }
}

