/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.pattern;

import com.google.common.cache.Cache;
import com.lucidworks.fusion.connector.checker.checkers.pattern.AbstractPatternChecker;
import com.lucidworks.fusion.connector.checker.config.RegexConfig;
import com.lucidworks.fusion.connector.checker.input.NamedCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import java.util.Set;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexChecker
extends AbstractPatternChecker {
    private static final Logger logger = LoggerFactory.getLogger(RegexChecker.class);
    public static final String MATCHES_EXCLUSION_REGEX = "matches-exclusion-regex";
    public static final String DOES_NOT_MATCH_INCLUSIVE_REGEX = "does-not-match-inclusive-regex";
    private final Set<String> excludeRegexes;
    private final Set<String> includeRegexes;
    private ThreadLocal<Set<Matcher>> excludeMatchers;
    private ThreadLocal<Set<Matcher>> includeMatchers;

    public RegexChecker(RegexConfig.Properties regexConfig) {
        super(regexConfig.regexCacheSize());
        this.excludeRegexes = regexConfig.exclusiveRegexes();
        this.includeRegexes = regexConfig.inclusiveRegexes();
        this.excludeMatchers = RegexChecker.makeThreadLocalMatchers(this.excludeRegexes);
        this.includeMatchers = RegexChecker.makeThreadLocalMatchers(this.includeRegexes);
    }

    @Override
    protected CheckerResult specificCheck(NamedCheckerInput namedCheckerInput) {
        String name = namedCheckerInput.getName();
        for (Matcher excludeMatcher : this.excludeMatchers.get()) {
            if (!excludeMatcher.reset(name).matches()) continue;
            if (this.illegalLinksCache.isPresent()) {
                ((Cache)this.illegalLinksCache.get()).put((Object)name, (Object)MATCHES_EXCLUSION_REGEX);
            }
            logger.debug("Name matches exclude pattern: '{}'", (Object)name);
            return FailedCheckerResult.failedResult(MATCHES_EXCLUSION_REGEX);
        }
        if (!RegexChecker.checkInclusion(name, this.includeMatchers.get())) {
            if (this.illegalLinksCache.isPresent()) {
                ((Cache)this.illegalLinksCache.get()).put((Object)name, (Object)DOES_NOT_MATCH_INCLUSIVE_REGEX);
            }
            logger.debug("Name does not match any include regex: '{}'", (Object)name);
            return FailedCheckerResult.failedResult(DOES_NOT_MATCH_INCLUSIVE_REGEX);
        }
        if (this.legalLinksCache.isPresent()) {
            ((Cache)this.legalLinksCache.get()).put((Object)name, (Object)true);
        }
        return new PassedCheckerResult();
    }
}

