/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.mimetype;

import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.config.MimeTypeConfig;
import com.lucidworks.fusion.connector.checker.input.MimeTypeCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import java.util.Collection;

public class MimeTypeChecker
implements Checker<MimeTypeCheckerInput> {
    public static final String MIME_TYPE_NOT_ALLOWED = "mime-type-not-allowed";
    public static final String EXCLUDED_MIME_TYPE = "excluded-mime-type";
    private final MimeTypeConfig.Properties config;

    public MimeTypeChecker(MimeTypeConfig.Properties config) {
        this.config = config;
    }

    @Override
    public CheckerResult apply(MimeTypeCheckerInput input) {
        String mimeType = input.getMimeType();
        if (!this.isNullOrEmpty(this.config.includedMimeTypes())) {
            if (!this.config.includedMimeTypes().contains(mimeType)) {
                return FailedCheckerResult.failedResult(MIME_TYPE_NOT_ALLOWED);
            }
        } else if (!this.isNullOrEmpty(this.config.excludedMimeTypes()) && this.config.excludedMimeTypes().contains(mimeType)) {
            return FailedCheckerResult.failedResult(EXCLUDED_MIME_TYPE);
        }
        return new PassedCheckerResult();
    }

    private <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }
}

