/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.factory;

import com.google.common.collect.ImmutableMap;
import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.checkers.depth.DepthChecker;
import com.lucidworks.fusion.connector.checker.checkers.factory.CheckerFactory;
import com.lucidworks.fusion.connector.checker.checkers.mimetype.MimeTypeChecker;
import com.lucidworks.fusion.connector.checker.checkers.pattern.ExtensionChecker;
import com.lucidworks.fusion.connector.checker.checkers.pattern.RegexChecker;
import com.lucidworks.fusion.connector.checker.checkers.size.SizeChecker;
import com.lucidworks.fusion.connector.checker.config.DepthLimitConfig;
import com.lucidworks.fusion.connector.checker.config.ExtensionConfig;
import com.lucidworks.fusion.connector.checker.config.MimeTypeConfig;
import com.lucidworks.fusion.connector.checker.config.RegexConfig;
import com.lucidworks.fusion.connector.checker.config.SizeLimitConfig;
import com.lucidworks.fusion.schema.Model;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCheckerFactory
implements CheckerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCheckerFactory.class);
    private static final Map<Class<? extends Model>, Class<? extends Checker>> MAPPINGS = ImmutableMap.builder().put(SizeLimitConfig.Properties.class, SizeChecker.class).put(DepthLimitConfig.Properties.class, DepthChecker.class).put(MimeTypeConfig.Properties.class, MimeTypeChecker.class).put(ExtensionConfig.Properties.class, ExtensionChecker.class).put(RegexConfig.Properties.class, RegexChecker.class).build();

    @Override
    public <C extends Model, CHECKER extends Checker> Optional<CHECKER> create(C config) {
        try {
            Class<? extends Checker> stageClass = MAPPINGS.get(config._type());
            if (stageClass == null) {
                logger.warn("Couldn't find a Checker implementation for configuration type: [{}]", (Object)config._type());
                return Optional.empty();
            }
            Constructor<? extends Checker> constructor = stageClass.getConstructor(config._type());
            return Optional.of(constructor.newInstance(config));
        }
        catch (Exception e) {
            logger.warn("Can not instantiate Checker from configuration: [{}]", (Object)config._type());
            return Optional.empty();
        }
    }
}

