/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor.model.gson;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImmutableListTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!ImmutableList.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                return ImmutableList.copyOf((Collection)((List)delegate.read(in)));
            }
        };
    }

    public static <T> InstanceCreator<List<T>> newCreator() {
        return type -> new ArrayList();
    }
}

