/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.lucidworks.connectors.components.processor.model.HostnameHelper;
import com.lucidworks.connectors.components.processor.model.gson.AnnotationExclusionStrategy;
import com.lucidworks.connectors.components.processor.model.gson.ImmutableListTypeAdapterFactory;
import com.lucidworks.connectors.components.processor.model.gson.ImmutableMapTypeAdapterFactory;
import com.lucidworks.connectors.components.processor.model.gson.ImmutableSetTypeAdapterFactory;
import com.lucidworks.connectors.components.processor.model.gson.MapBuilderHelper;
import com.lucidworks.connectors.components.processor.model.gson.MapMetadataDeserializer;
import com.lucidworks.connectors.components.processor.model.gson.MetadataFieldNamingStrategy;
import com.lucidworks.connectors.components.processors.IncompatibleDataInput;
import com.lucidworks.connectors.components.processors.InitialInput;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.MapBuilder;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import com.ryanharter.auto.value.gson.GenerateTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonModel {
    private static final Logger logger = LoggerFactory.getLogger(GsonModel.class);
    private static final Type METADATA_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final String ITEM_TYPE = "_input_type_";

    private static GsonBuilder genericBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ImmutableMapTypeAdapterFactory()).registerTypeAdapter(ImmutableMap.class, ImmutableMapTypeAdapterFactory.newCreator()).registerTypeAdapterFactory((TypeAdapterFactory)new ImmutableSetTypeAdapterFactory()).registerTypeAdapter(ImmutableSet.class, ImmutableSetTypeAdapterFactory.newCreator()).registerTypeAdapterFactory((TypeAdapterFactory)new ImmutableListTypeAdapterFactory()).registerTypeAdapter(ImmutableList.class, ImmutableListTypeAdapterFactory.newCreator()).registerTypeAdapter(METADATA_TYPE, (Object)MapMetadataDeserializer.create()).registerTypeAdapterFactory(GenerateTypeAdapter.FACTORY);
    }

    public static TypedInput of(FetchInput input) {
        if (!input.hasId()) {
            return new InitialInput();
        }
        try {
            return GsonModel.of(input.getMetadata());
        }
        catch (Exception e) {
            logger.error("Input={} failed while parsing", (Object)input.getId(), (Object)e);
            String message = String.format("Error message: Incompatible data in CrawlDB, please clear CrawlDB collection and crawl from scratch. Cause: %s", e.getMessage());
            return IncompatibleDataInput.builder().inputId(input.getId()).error(message).build();
        }
    }

    @VisibleForTesting
    public static TypedInput of(Map<String, Object> raw) throws ClassNotFoundException {
        String rawType;
        if (raw == null) {
            raw = new HashMap<String, Object>();
        }
        if ((rawType = (String)raw.get(ITEM_TYPE)) == null) {
            throw new IllegalArgumentException("Metadata without _input_type_");
        }
        logger.trace("Item raw.type={}", (Object)rawType);
        Class<?> c = Class.forName(rawType);
        logger.debug("Item type={} from raw={}", (Object)c.getSimpleName(), (Object)rawType);
        return MetadataHelper.mapToTypedInput(raw, c);
    }

    public static GsonBuilder gsonBuilder() {
        return GsonModel.genericBuilder();
    }

    static class PartComparator
    implements Comparator<Part> {
        PartComparator() {
        }

        @Override
        public int compare(Part a, Part b) {
            return a.index - b.index;
        }
    }

    static class Part {
        int index;
        String value;

        Part(int index, String value) {
            this.index = index;
            this.value = value;
        }
    }

    static class TypedInputAdapter
    extends TypeAdapter<TypedInput> {
        private static final String INNER_OBJECT_TYPE = "_inner_object_";
        private static final String INNER_ARRAY_TYPE = "_inner_array_";
        private static final JsonPrimitive INNER_OBJECT_PRIMITIVE = new JsonPrimitive("_inner_object_");
        private static final JsonPrimitive INNER_ARRAY_PRIMITIVE = new JsonPrimitive("_inner_array_");
        private static final String SPLIT_PART = "___part_";
        private static final String SPLIT_NO_VALUE = "-no-value-";
        private static final int SPLIT_CHUNK = Integer.getInteger("components.model.split.chunk", 11000);
        private final TypeAdapter<JsonElement> elementAdapter;
        private final TypeAdapter<TypedInput> delegate;

        TypedInputAdapter(TypeAdapter<JsonElement> elementAdapter, TypeAdapter<TypedInput> delegate) {
            this.elementAdapter = elementAdapter;
            this.delegate = delegate;
        }

        public void write(JsonWriter out, TypedInput value) throws IOException {
            JsonElement tree = this.delegate.toJsonTree((Object)value);
            JsonObject typed = tree.getAsJsonObject();
            HashSet elements = new HashSet(typed.entrySet());
            for (Map.Entry entry : elements) {
                String inner;
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    JsonObject innerObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    innerObject.add(INNER_OBJECT_TYPE, (JsonElement)INNER_OBJECT_PRIMITIVE);
                    inner = this.elementAdapter.toJson((Object)innerObject);
                    if (inner.length() > SPLIT_CHUNK) {
                        Iterable chunks = Splitter.fixedLength((int)SPLIT_CHUNK).split((CharSequence)inner);
                        int i = 0;
                        for (String chunk : chunks) {
                            typed.add(SPLIT_PART + (String)entry.getKey() + "_" + i++, (JsonElement)new JsonPrimitive(chunk));
                        }
                        continue;
                    }
                    typed.add((String)entry.getKey(), (JsonElement)new JsonPrimitive(inner));
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                JsonArray innerArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                innerArray.add((JsonElement)INNER_ARRAY_PRIMITIVE);
                inner = this.elementAdapter.toJson((Object)innerArray);
                typed.add((String)entry.getKey(), (JsonElement)new JsonPrimitive(inner));
            }
            this.elementAdapter.write(out, (Object)tree);
        }

        public TypedInput read(JsonReader in) throws IOException {
            JsonElement tree = (JsonElement)this.elementAdapter.read(in);
            JsonObject typed = tree.getAsJsonObject();
            HashSet<Map.Entry<String, JsonElement>> elements = new HashSet<Map.Entry<String, JsonElement>>(typed.entrySet());
            Set<Map.Entry<String, JsonElement>> parts = TypedInputAdapter.assemble(elements);
            for (Map.Entry<String, JsonElement> entry : parts) {
                JsonElement realObject;
                JsonPrimitive innerObject;
                if (!entry.getValue().isJsonPrimitive() || !(innerObject = entry.getValue().getAsJsonPrimitive()).isString()) continue;
                String inner = innerObject.getAsString();
                if (inner.contains(INNER_OBJECT_TYPE)) {
                    realObject = (JsonElement)this.elementAdapter.fromJson(inner);
                    realObject.getAsJsonObject().remove(INNER_OBJECT_TYPE);
                    typed.add(entry.getKey(), realObject);
                    continue;
                }
                if (!inner.contains(INNER_ARRAY_TYPE)) continue;
                realObject = (JsonElement)this.elementAdapter.fromJson(inner);
                realObject.getAsJsonArray().remove((JsonElement)INNER_ARRAY_PRIMITIVE);
                typed.add(entry.getKey(), realObject);
            }
            return (TypedInput)this.delegate.fromJsonTree(tree);
        }

        private static Set<Map.Entry<String, JsonElement>> assemble(Set<Map.Entry<String, JsonElement>> elements) {
            HashSet<Map.Entry<String, JsonElement>> jsonParts = new HashSet<Map.Entry<String, JsonElement>>();
            HashMap<String, List<Part>> eachPart = new HashMap<String, List<Part>>();
            for (Map.Entry<String, JsonElement> entry : elements) {
                if (entry.getValue().isJsonPrimitive() && entry.getKey().startsWith(SPLIT_PART)) {
                    TypedInputAdapter.putPart(eachPart, entry);
                    continue;
                }
                jsonParts.add(entry);
            }
            for (Map.Entry<String, Object> entry : eachPart.entrySet()) {
                List moreParts = (List)entry.getValue();
                moreParts.sort(new PartComparator());
                StringBuilder inner = new StringBuilder();
                for (Part a : moreParts) {
                    inner.append(a.value);
                }
                AbstractMap.SimpleEntry<String, JsonPrimitive> jsonEntry = new AbstractMap.SimpleEntry<String, JsonPrimitive>(entry.getKey(), new JsonPrimitive(inner.toString()));
                jsonParts.add(jsonEntry);
            }
            return jsonParts;
        }

        private static void putPart(Map<String, List<Part>> eachPart, Map.Entry<String, JsonElement> entry) {
            JsonPrimitive innerObject = entry.getValue().getAsJsonPrimitive();
            String key = entry.getKey().replace(SPLIT_PART, "");
            int index = key.lastIndexOf("_");
            Iterable chunks = Splitter.fixedLength((int)index).split((CharSequence)key);
            String newKey = (String)Iterables.getFirst((Iterable)chunks, (Object)SPLIT_NO_VALUE);
            String part = (String)Iterables.getLast((Iterable)chunks, (Object)SPLIT_NO_VALUE);
            if (SPLIT_NO_VALUE.equals(newKey) || SPLIT_NO_VALUE.equals(part)) {
                return;
            }
            if (Strings.isNullOrEmpty((String)newKey) || Strings.isNullOrEmpty((String)part)) {
                return;
            }
            List<Object> parts = eachPart.containsKey(newKey) ? eachPart.get(newKey) : new ArrayList();
            part = part.replace("_", "");
            try {
                int partIndex = Integer.parseInt(part);
                parts.add(new Part(partIndex, innerObject.getAsString()));
                eachPart.put(newKey, parts);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class TypedInputAdapterFactory
    implements TypeAdapterFactory {
        TypedInputAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TypedInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypedInputAdapter((TypeAdapter<JsonElement>)elementAdapter, (TypeAdapter<TypedInput>)delegate);
        }
    }

    private static class FieldsHelper {
        private static final Gson FIELDS_GSON = FieldsHelper.fieldsBuilder().create();

        private FieldsHelper() {
        }

        static GsonBuilder fieldsBuilder() {
            return GsonModel.genericBuilder().setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()});
        }

        static <T> Map<String, Object> serializeWithExclude(T model) {
            Map m = (Map)FIELDS_GSON.fromJson(FIELDS_GSON.toJsonTree(model), METADATA_TYPE);
            logger.trace("Serializing fields type={}, map={}", (Object)model.getClass().getSimpleName(), (Object)m);
            return m;
        }

        static Map<String, Object> toFields(Map<String, Object> fields, Map<String, Object> additionalFields) {
            fields.put("crawlHostname", HostnameHelper.HOST_NAME);
            if (additionalFields != null) {
                fields.putAll(additionalFields);
            }
            fields.remove("id");
            fields.remove(GsonModel.ITEM_TYPE);
            return fields;
        }
    }

    private static class MetadataHelper {
        private static final Gson METADATA_GSON = MetadataHelper.metadataBuilder().create();

        private MetadataHelper() {
        }

        static GsonBuilder metadataBuilder() {
            return GsonModel.genericBuilder().setFieldNamingStrategy((FieldNamingStrategy)new MetadataFieldNamingStrategy()).registerTypeAdapterFactory((TypeAdapterFactory)new TypedInputAdapterFactory()).registerTypeAdapter(METADATA_TYPE, (Object)MapMetadataDeserializer.create());
        }

        static <T extends TypedInput> T mapToTypedInput(String raw, Class<T> clazz) {
            return (T)((TypedInput)METADATA_GSON.fromJson(raw, clazz));
        }

        static <T extends TypedInput> T mapToTypedInput(Map<String, Object> raw, Class<T> clazz) {
            return (T)((TypedInput)MetadataHelper.toMap(raw, clazz));
        }

        static <T> T toMap(Map<String, Object> map, Class<T> clazz) {
            return (T)METADATA_GSON.fromJson(METADATA_GSON.toJsonTree(map), clazz);
        }

        static <T> Map<String, Object> serialize(T model) {
            JsonElement jsonElement = METADATA_GSON.toJsonTree(model);
            Map m = (Map)METADATA_GSON.fromJson(jsonElement, METADATA_TYPE);
            logger.trace("Serializing metadata fields type={}, map={}", (Object)model.getClass().getSimpleName(), (Object)m);
            return m;
        }

        static <T extends TypedInput> Map<String, Object> typedMap(T model) {
            Map<String, Object> item = MetadataHelper.serialize(model);
            if (!item.containsKey(GsonModel.ITEM_TYPE)) {
                item.put(GsonModel.ITEM_TYPE, model.getClass().getCanonicalName());
            }
            item.remove("id");
            logger.trace("Serializing object type={}, map={}", (Object)model.getClass().getSimpleName(), item);
            return item;
        }
    }

    public static interface TypedInput {
        public String inputId();

        default public Consumer<MapBuilder> toItemMetadata() {
            Map<String, Object> metadata = MetadataHelper.typedMap(this);
            return MapBuilderHelper.toMapBuilder(metadata);
        }

        default public Consumer<MapBuilder> toItemFields() {
            Map<String, Object> fields = FieldsHelper.toFields(FieldsHelper.serializeWithExclude(this), Collections.emptyMap());
            return MapBuilderHelper.toMapBuilder(fields);
        }

        default public Consumer<MapBuilder> toItemFields(Object other) {
            Map<String, Object> fields = FieldsHelper.toFields(FieldsHelper.serializeWithExclude(this), FieldsHelper.serializeWithExclude(other));
            return MapBuilderHelper.toMapBuilder(fields);
        }

        default public Consumer<MapBuilder> toItemFields(Map<String, Object> additionalFields) {
            Map<String, Object> fields = FieldsHelper.toFields(FieldsHelper.serializeWithExclude(this), additionalFields);
            return MapBuilderHelper.toMapBuilder(fields);
        }

        default public Consumer<MapBuilder> toItemFields(Object other, Map<String, Object> additionalFields) {
            Map<String, Object> fields = FieldsHelper.toFields(FieldsHelper.serializeWithExclude(this), FieldsHelper.serializeWithExclude(other));
            return MapBuilderHelper.toMapBuilder(FieldsHelper.toFields(fields, additionalFields));
        }
    }
}

