/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor;

import com.lucidworks.connectors.components.processor.EmitterConfig;
import com.lucidworks.connectors.components.processor.TypedOutputs;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.connectors.components.processor.model.TypedAccessControl;
import com.lucidworks.connectors.components.processor.model.TypedCandidate;
import com.lucidworks.connectors.components.processor.model.TypedCheckpoint;
import com.lucidworks.connectors.components.processor.model.TypedContent;
import com.lucidworks.connectors.components.processor.model.TypedDelete;
import com.lucidworks.connectors.components.processor.model.TypedDeleteAccessControl;
import com.lucidworks.connectors.components.processor.model.TypedDocument;
import com.lucidworks.connectors.components.processor.model.TypedError;
import com.lucidworks.connectors.components.processor.model.TypedInputStreamContent;
import com.lucidworks.connectors.components.processor.model.TypedSkip;
import com.lucidworks.fusion.connector.plugin.api.cache.CacheManager;
import com.lucidworks.fusion.connector.plugin.api.exceptions.ContentEmitException;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.AccessControlBuilder;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.MapBuilder;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Candidate;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Checkpoint;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Content;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Delete;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Document;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Error;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Skip;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.security.DeleteAccessControlItem;
import com.lucidworks.fusion.schema.ModelGenerator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TypedEmitter {
    private static final String DN_FIELD = "AC_DN";
    private static final String UPN_FIELD = "AC_UPN";
    private static final String SAM_FIELD = "AC_SAM";
    private static final String SID_FIELD = "AC_SID";
    private final ContentFetcher.FetchContext ctx;
    private final EmitterConfig config;

    public TypedEmitter(EmitterConfig config, ContentFetcher.FetchContext ctx) {
        this.ctx = ctx;
        this.config = config;
    }

    public FetchResult newResult() {
        return this.ctx.newResult();
    }

    public CacheManager<String> cache() {
        return this.ctx.cache();
    }

    @Deprecated
    public FetchInput getFetchInput() {
        return this.ctx.getFetchInput();
    }

    public void emitError(Supplier<TypedError> supplier) {
        TypedError emitted = supplier.get();
        if (this.config.isRetryPolicyEnabled()) {
            ((Error.Emitter)((Error.Emitter)this.ctx.newError(emitted.getId(), emitted.error()).retryPolicy(retryPolicy -> {
                retryPolicy.setMaxRetries(this.config.maxRetries());
                retryPolicy.setDelayInSeconds(this.config.retryDelayInSeconds());
            })).metadata(mapBuilder -> mapBuilder.merge(this.ctx.getFetchInput().getMetadata()))).emit();
        } else {
            ((Error.Emitter)this.ctx.newError(emitted.getId(), emitted.error()).metadata(emitted.metadata())).emit();
        }
    }

    public void emitError(GsonModel.TypedInput input, String error) {
        this.emitError(() -> TypedOutputs.emittedError(input, error));
    }

    public void emitErrorWithNoRetry(Supplier<TypedError> supplier) {
        TypedError emitted = supplier.get();
        ((Error.Emitter)this.ctx.newError(emitted.getId(), emitted.error()).metadata(emitted.metadata())).emit();
    }

    public void emitErrorWithNoRetry(GsonModel.TypedInput input, String error) {
        this.emitErrorWithNoRetry(() -> TypedOutputs.emittedError(input, error));
    }

    public void emitCheckpoint(Supplier<TypedCheckpoint> supplier) {
        TypedCheckpoint emitted = supplier.get();
        ((Checkpoint.Emitter)((Checkpoint.Emitter)((Checkpoint.Emitter)this.ctx.newCheckpoint(emitted.getId()).withParentId(emitted.parentId())).withTargetPhase(emitted.targetPhase())).metadata(emitted.metadata())).emit();
    }

    public void emitSkip(Supplier<TypedSkip> supplier) {
        TypedSkip emitted = supplier.get();
        ((Skip.Emitter)this.ctx.newSkip(emitted.getId()).withConditions(emitted.conditions())).emit();
    }

    public void emitCandidate(Supplier<TypedCandidate> supplier) {
        this.emitCandidate(supplier, m -> {});
    }

    public void emitCandidate(Supplier<TypedCandidate> supplier, Consumer<MapBuilder> fields) {
        TypedCandidate emitted = supplier.get();
        ((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)((Candidate.Emitter)this.ctx.newCandidate(emitted.getId()).withTransient(emitted.isTransient())).withAffinityKey(emitted.affinityKey())).withIsLeafNode(emitted.isLeafNode())).withLastModified(emitted.lastModified())).withParentId(emitted.parentId())).withSignature(emitted.signature())).withTargetPhase(emitted.targetPhase())).metadata(emitted.metadata())).fields(fields)).emit();
    }

    public void emitSkip(GsonModel.TypedInput input, Set<String> conditions) {
        this.emitSkip(() -> TypedOutputs.emittedSkip(input, conditions));
    }

    public void emitSkip(GsonModel.TypedInput input, String condition, String ... conditions) {
        HashSet<String> c = new HashSet<String>();
        c.add(condition);
        if (conditions != null) {
            c.addAll(Arrays.asList(conditions));
        }
        this.emitSkip(() -> TypedOutputs.emittedSkip(input, c));
    }

    public void emitDelete(Supplier<TypedDelete> supplier) {
        TypedDelete emitted = supplier.get();
        ((Delete.Emitter)((Delete.Emitter)this.ctx.newDelete(emitted.getId()).withConditions(emitted.conditions())).withQuery(emitted.query(), emitted.matchAll())).emit();
    }

    public void emitDocument(Supplier<TypedDocument> supplier) {
        TypedDocument emitted = supplier.get();
        Document.Emitter document = (Document.Emitter)((Document.Emitter)((Document.Emitter)this.ctx.newDocument(emitted.getId()).withParentId(emitted.parentId())).fields(emitted.fields())).metadata(emitted.metadata());
        if (emitted.acls() != null && !emitted.acls().isEmpty()) {
            document.withACLs(emitted.acls());
        }
        if (emitted.denyAcls() != null && !emitted.denyAcls().isEmpty()) {
            document.withDenyACLs(emitted.denyAcls());
        }
        document.emit();
    }

    @Deprecated
    public void emitContent(Supplier<TypedContent> supplier) {
        TypedContent emitted = supplier.get();
        Content.Emitter content = (Content.Emitter)((Content.Emitter)((Content.Emitter)((Content.Emitter)this.ctx.newContent(emitted.getId(), emitted.getInputStreamSupplier()).withResourceName(emitted.resourceName())).withParentId(emitted.parentId())).fields(emitted.fields())).metadata(emitted.metadata());
        if (emitted.acls() != null && !emitted.acls().isEmpty()) {
            content.withACLs(emitted.acls());
        }
        if (emitted.denyAcls() != null && !emitted.denyAcls().isEmpty()) {
            content.withDenyACLs(emitted.denyAcls());
        }
        content.emit();
    }

    public void emitContentOrThrow(Supplier<TypedInputStreamContent> supplier) throws ContentEmitException {
        TypedInputStreamContent emitted = supplier.get();
        Content.ContentEmitter content = (Content.ContentEmitter)((Content.ContentEmitter)((Content.ContentEmitter)((Content.ContentEmitter)this.ctx.newContent(emitted.getId(), emitted.getInputStream()).withResourceName(emitted.resourceName())).withParentId(emitted.parentId())).fields(emitted.fields())).metadata(emitted.metadata());
        if (emitted.acls() != null && !emitted.acls().isEmpty()) {
            content.withACLs(emitted.acls());
        }
        if (emitted.denyAcls() != null && !emitted.denyAcls().isEmpty()) {
            content.withDenyACLs(emitted.denyAcls());
        }
        content.emit();
    }

    public void emitDeleteAccessControl(Supplier<TypedDeleteAccessControl> supplier) {
        TypedDeleteAccessControl emitted = supplier.get();
        DeleteAccessControlItem.Emitter emitter = (DeleteAccessControlItem.Emitter)((DeleteAccessControlItem.Emitter)this.ctx.newDeleteAccessControlItem(emitted.getId()).withConditions(emitted.conditions())).withQuery(emitted.query(), emitted.matchAll());
        if (emitted.inboundDepthLimit() != -1) {
            emitter.withDeleteChildrenFromInbound(emitted.inboundDepthLimit());
        }
        if (emitted.outboundDepthLimit() != -1) {
            emitter.withDeleteChildrenFromOutbound(emitted.outboundDepthLimit());
        }
        if (emitted.deleteInCascadeFromInbound()) {
            emitter.withDeleteInCascadeFromInbound();
        }
        if (emitted.deleteInCascadeFromOutbound()) {
            emitter.withDeleteInCascadeFromOutbound();
        }
        if (emitted.deleteReferenceFromInbound()) {
            emitter.withDeleteReferenceFromInbound();
        }
        if (emitted.deleteReferenceFromOutbound()) {
            emitter.withDeleteReferenceFromOutbound();
        }
        if (emitted.skipDelete()) {
            emitter.withSkipDeleteItem();
        }
        emitter.emit();
    }

    public void emitAccessControl(Supplier<TypedAccessControl> supplier) {
        this.emitAccessControl(supplier, m -> {});
    }

    public void emitAccessControl(Supplier<TypedAccessControl> supplier, Consumer<MapBuilder> additionalFields) {
        TypedAccessControl emitted = supplier.get();
        Consumer<MapBuilder> fromEmitted = emitted.fields();
        Consumer<MapBuilder> fields = fromEmitted.andThen(additionalFields).andThen(TypedEmitter.aclFields(emitted));
        ((AccessControlBuilder.Emitter)((AccessControlBuilder.Emitter)((AccessControlBuilder.Emitter)((AccessControlBuilder.Emitter)((AccessControlBuilder.Emitter)this.ctx.newAccessControl(emitted.getId()).metadata(emitted.metadata())).fields(fields)).addAllInbound(emitted.inbounds())).addAllOutbound(emitted.outbounds())).withIsLeafNode(emitted.isLeafNode())).emit();
    }

    private static Consumer<MapBuilder> aclFields(TypedAccessControl emitted) {
        return m -> {
            String dn = emitted.withDN().orElse(ModelGenerator.randomId());
            m.setString(DN_FIELD, dn);
            String sam = emitted.withSAM().orElse(ModelGenerator.randomId());
            m.setString(SAM_FIELD, sam);
            String sid = emitted.withSID().orElse(ModelGenerator.randomId());
            m.setString(SID_FIELD, sid);
            String upn = emitted.withUPN().orElse(ModelGenerator.randomId());
            m.setString(UPN_FIELD, upn);
        };
    }
}

