/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.events;

import com.google.common.collect.Lists;
import com.lucidworks.connectors.components.events.EventContext;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsReducer {
    private static final Logger logger = LoggerFactory.getLogger(EventsReducer.class);
    private static final List<EventContext.EventType> VALID_EVENTS = Lists.newArrayList((Object[])new EventContext.EventType[]{EventContext.EventType.FULL_INDEX, EventContext.EventType.PARTIAL_INDEX, EventContext.EventType.DELETE});
    private final Map<String, EventContext> events = new HashMap<String, EventContext>();

    private EventsReducer() {
    }

    public static EventsReducer create() {
        return new EventsReducer();
    }

    public <E extends EventContext> EventsReducer reduceEvents(Supplier<List<E>> list) {
        return this.reduceEvents(list.get());
    }

    public <E extends EventContext> EventsReducer reduceEvents(List<E> list) {
        this.reduce(list);
        return this;
    }

    public <E extends EventContext> EventsReducer reduceEvents(Iterator<List<E>> iterator) {
        iterator.forEachRemaining(this::reduce);
        return this;
    }

    public Map<String, EventContext> relevantEvents() {
        return this.events;
    }

    public void emitRelevantEvents(TypedEmitter ctx) {
        this.events.values().forEach(event -> ctx.emitCandidate(event::candidate));
    }

    private <E extends EventContext> Map<String, EventContext> reduce(List<E> list) {
        HashMap<String, EventContext> old = new HashMap<String, EventContext>(this.events);
        Map<String, EventContext> current = this.reduceEventsObjectsPage(list);
        return Stream.of(old, current).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this::doReduction, () -> this.events));
    }

    private <E extends EventContext> Map<String, EventContext> reduceEventsObjectsPage(List<E> eventsObjectsPage) {
        if (eventsObjectsPage.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, List<EventContext>> groups = eventsObjectsPage.stream().collect(Collectors.groupingBy(EventContext::objectId));
        return groups.values().stream().map(this::filterInvalidEvents).filter(filtered -> !filtered.isEmpty()).map(this::findMostRelevant).collect(Collectors.toMap(EventContext::objectId, e -> e));
    }

    private List<EventContext> filterInvalidEvents(List<EventContext> events) {
        return events.stream().filter(event -> VALID_EVENTS.contains((Object)event.type())).collect(Collectors.toList());
    }

    private EventContext findMostRelevant(List<EventContext> events) {
        if (events.size() == 1) {
            return events.get(0);
        }
        return this.findMostRelevant(events.get(0), events.subList(1, events.size()));
    }

    private EventContext findMostRelevant(EventContext identity, List<EventContext> events) {
        return events.stream().reduce(identity, this::doReduction);
    }

    private EventContext doReduction(EventContext left, EventContext right) {
        EventContext.EventType typeLeft = left.type();
        EventContext.EventType typeRight = right.type();
        logger.debug("Reducing L{}/{} R{}/{}", new Object[]{left.objectId(), typeLeft, right.objectId(), typeRight});
        if (typeLeft.equals((Object)typeRight)) {
            return right;
        }
        if (typeLeft.equals((Object)EventContext.EventType.FULL_INDEX) && typeRight.equals((Object)EventContext.EventType.PARTIAL_INDEX)) {
            return left;
        }
        return right;
    }

    public void processEvents(Consumer<EventContext> eventConsumer) {
        this.events.values().forEach(eventConsumer);
    }
}

